// Scene_BattleのcreateAllWindowsメソッドをオーバーライド
var _Scene_Battle_createAllWindows = Scene_Battle.prototype.createAllWindows;
Scene_Battle.prototype.createAllWindows = function() {
    _Scene_Battle_createAllWindows.call(this);
    this.createVariableWindow();
};

// 変数表示ウィンドウを作成
Scene_Battle.prototype.createVariableWindow = function() {
    this._variableWindow = new Window_Variable();
    this.addWindow(this._variableWindow);
};

// Window_Baseを継承したカスタムウィンドウクラスを作成
function Window_Variable() {
    this.initialize.apply(this, arguments);
}

Window_Variable.prototype = Object.create(Window_Base.prototype);
Window_Variable.prototype.constructor = Window_Variable;

Window_Variable.prototype.initialize = function() {
    var width = 240;
    var height = this.fittingHeight(1);
    Window_Base.prototype.initialize.call(this, 0, 0, width, height);
    this.refresh();
};

Window_Variable.prototype.refresh = function() {
    this.contents.clear();
    var value = $gameVariables.value(26); // 変数0026の値を取得
    this.drawText('Variable 26: ' + value, 0, 0, this.contents.width);
};

// updateメソッドをオーバーライドして変数の値をリアルタイムで更新
Window_Variable.prototype.update = function() {
    Window_Base.prototype.update.call(this);
    this.refresh();
};
